//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.5

import wesual.Stage 1.0
import wesual.Ui     1.0

ContainerOption {
    defaultValue : 0

    property string label
    property var    options

    readonly property int option : value || 0

    Column {
        property ContainerOption containerOption

        spacing : 9

        UiLabel { text : containerOption.label }

        Column {
            spacing : 9

            UiRadioButtonGroup {
                id : buttonGroup

                activeButton : {
                    if (buttons.count > containerOption.value) {
                        return buttons.itemAt(containerOption.value);
                    }

                    return null;
                }
            }

            Repeater {
                id : buttons

                model    : containerOption.options
                delegate : UiRadioButton {
                    text      : modelData
                    bindable  : true
                    group     : buttonGroup
                    onClicked : containerOption.updateValue(index)
                }
            }
        }
    }
}
